



export class VatListWidget {
	
	container = null;
	vats = null;
	
	ezTpl = null;
	
	tpl = `
		<div class="page-header">
			<div class="toolbox">
				<a href="{{appUrl('/masterdata/')}}" class="fa fa-chevron-circle-left"></a>
				<a href="{{appUrl('/masterdata/sales/vat/edit/')}}" class="fa fa-plus"></a>
			</div>
			
			<h1>Btw tarieven</h1>
		</div>
		
		<div ez-if="vats == null">
			Loading...
		</div>
		<div ez-if="vats != null">
			<table class="table">
				<thead>
					<tr>
						<th></th>
						<th>Omschrijving</th>
						<th>Percentage</th>
						<th>Standaard gekozen</th>
						<th>Zichtbaar</th>
						<th>Laatst bewerkt</th>
					</tr>
				</thead>
				<tbody  ez-for="vats" ez-item="vat" class="tbody-vats">
					<tr [onclick]="widget.editVat" class="pointer" vat-id="{{vat.vatId}}">
						<td style="width: 50px;"><i class="fa fa-bars sort-handle"></i></td>
						<td>{{vat.description}}</td>
						<td>{{vat.percentage}}</td>
						<td>{{vat.defaultSelected ? 'Ja' : 'Nee' }}</td>
						<td>{{vat.visible ? 'Ja' : 'Nee' }}</td>
						<td>{{ format_datetime(vat.edited, {dmy: true}) }}</td>
						<td class="actions">
							<a href="{{appUrl('/masterdata/sales/vat/edit/?id='+vat.vatId)}}" class="fa fa-pencil"></a>
						</td>
					</tr>
				</tbody>
					
				<tbody ez-if="vats.length == 0">
					<tr>
						<td colspan="6" class="no-results">
							Geen resultaten gevonden
						</td>
					</tr>
				</tbody>
			</table>
		</div>
	`;
	
	
	editVat(evt, tr) {
		let vatid = tr.getAttribute('vat-id');
		
		gotoRoute( '/masterdata/sales/vat/edit/?id='+vatid );
	}


	render() {
		this.ezTpl = new EzTemplate( this.container );
		this.ezTpl.setVar('vats', this.vats);
		this.ezTpl.setObject('widget', this);
		this.ezTpl.loadHtml( this.tpl );
		this.ezTpl.render();

		$(this.container).find('.tbody-vats').sortable({
			handle: '.sort-handle',
			update: function() {
				this.saveSort();
			}.bind(this)
		});
		
	}
	
	saveSort() {
		let ids = [];
		$('.tbody-vats tr').each(function(index, node) {
			let id = $(node).attr('vat-id');
			ids.push(id);
		});
		
		postUrl( '/service/sales/vat.do', {
			a: 'updateSort',
			ids: ids.join(',')
		}).then( async function(e) {
			let json = await e.json();
			showToastMessage('Volgorde opgeslagen');
		}.bind(this) );
	}
	
	
	loadVats() {
		postUrl( '/service/sales/vat.do' )
		.then( async function(e) {
			let json = await e.json();
			if (json.error) {
				return showErrorWidget( json );
			}
			
			this.vats = json.vats;
			this.render();
			
		}.bind(this) );
	}
	
	
	init(e) {
		this.container = e;
		
		this.render();
		
		this.loadVats();
	}

}

